#include <amxmodx>
#include <cstrike>
#include <engine>

new const PLUGIN[]  = "Jetpack Lite";
new const VERSION[] = "1.0";
new const AUTHOR[]  = "v3x";//Magyarostotta: pocok5 

new const CVAR_JP_ACTIVE[] = "jp_active";
new const CVAR_JP_COST[]   = "jp_cost";
new const CVAR_JP_MAX[]    = "jp_max";
new const CVAR_JP_SPEED[]  = "jp_speed";
new const CVAR_JP_TRAIL[]  = "jp_trail";
new const CVAR_JP_DOD[]    = "jp_dropondeath";

new JP_SOUND[] = "jetpack.wav";

new flame , smoke;
new bool:has_jp[33];
new bool:has_started;
new frame[33];
new current_jps;

public plugin_init() {
	register_plugin(PLUGIN , VERSION , AUTHOR);

	register_clcmd("say /jetpack"  , "ClCmd_BuyJP");
	register_clcmd("jetpack"       , "ClCmd_BuyJP");
	register_clcmd("say /dropjp"   , "drop_jp");
	register_clcmd("dropjp"        , "drop_jp");
	//register_clcmd("amx_givejp"  , "ClCmd_GiveJP");

	register_cvar(CVAR_JP_ACTIVE   , "1");
	register_cvar(CVAR_JP_COST     , "2500");
	register_cvar(CVAR_JP_MAX      , "4");
	register_cvar(CVAR_JP_SPEED    , "500");
	register_cvar(CVAR_JP_TRAIL    , "1");
	register_cvar(CVAR_JP_DOD      , "1");

	register_event("DeathMsg" , "Event_DeathMsg" , "a");
	register_event("HLTV" , "did_not_start" , "a" , "1=0" , "2=0");

	register_logevent("did_start" , 2 , "1=Round_Start");

	register_touch("jetpack" , "player" , "mmm_touchy");

	set_task(300.0 , "Advertise");
}

public Advertise() {
	if(get_cvar_num(CVAR_JP_ACTIVE)) {
		client_print(0 , print_chat, "* A Jetpack vtelhez rd a chatbe /jetpack");
	}
	set_task(300.0 , "Advertise");
}

public did_not_start() {
	has_started = false;
	new ent = -1;
	while((ent = find_ent_by_class(ent , "jetpack")) != 0) {
		remove_entity(ent);
	}
	current_jps = 0;
	new aPlayers[32] , iNum , i;
	get_players(aPlayers , iNum);
	for(i = 1; i <= iNum; i++) {
		if(has_jp[aPlayers[i]]) {
			current_jps++;
		}
	}
}

public did_start() {
	has_started = true;
}

public client_connect(id) {
	has_jp[id] = false;
}

public client_disconnect(id) {
	has_jp[id] = false;
}

public plugin_precache() {
	smoke = precache_model("sprites/lightsmoke.spr");
	flame = precache_model("sprites/rjet1.spr"); // bm1, rjet1, stmbal1, WXplo1, xsmoke1, lightsmoke
	precache_model("models/p_egon.mdl");
	precache_model("models/w_egon.mdl");
	precache_sound(JP_SOUND);
}

public client_PreThink(id) {
	if(!get_cvar_num(CVAR_JP_ACTIVE)) {
		return PLUGIN_CONTINUE;
	}
	if(!is_user_connected(id) || !is_user_alive(id)) {
		return PLUGIN_CONTINUE;
	}
	if(!(get_user_button(id) & IN_JUMP)) {
		return PLUGIN_CONTINUE;
	}
	if(!has_started || !has_jp[id]) {
		return PLUGIN_CONTINUE;
	}
	new Float:fAim[3] , Float:fVelocity[3];
	VelocityByAim(id , get_cvar_num(CVAR_JP_SPEED) , fAim);

	fVelocity[0] = fAim[0];
	fVelocity[1] = fAim[1];
	fVelocity[2] = fAim[2];

	set_user_velocity(id , fVelocity);

	entity_set_int(id , EV_INT_gaitsequence , 6);

	emit_sound(id , CHAN_VOICE , JP_SOUND , 1.0 , ATTN_NORM , 0 , PITCH_NORM);

	if(frame[id] >= 3) {
		frame[id] = 0;
		if(get_cvar_num(CVAR_JP_TRAIL)) {
			smoke_effect(id);
		}
		entity_set_string(id , EV_SZ_weaponmodel , "models/p_egon.mdl");
	}
	frame[id]++;

	return PLUGIN_CONTINUE;
}

public smoke_effect(id) {
	new origin[3];
	get_user_origin(id, origin, 0);
	origin[2] = origin[2] - 10;

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(17);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]);
	write_short((get_cvar_num(CVAR_JP_TRAIL) == 1) ? smoke : flame);
	write_byte(10);
	write_byte(115);
	message_end();
}

public Event_DeathMsg() {
	if(get_cvar_num(CVAR_JP_DOD)) {
		drop_jp(read_data(2));
	} else {
		has_jp[read_data(2)] = false;
	}
}

public ClCmd_BuyJP(id) {
	if(!get_cvar_num(CVAR_JP_ACTIVE)) {
		client_print(id , print_chat , "[AMXX] Elnzst, de a Jetpack pillanatnyilag ki van kapcsolva");
		return PLUGIN_HANDLED;
	}

	if(!is_user_alive(id)) {
		client_print(id , print_chat , "[AMXX] Nemvehetsz Jetpackot amg halott vagy!");
		return PLUGIN_HANDLED;
	}

	if(has_jp[id]) {
		client_print(id , print_chat , "[AMXX] Neked mr van Jetpackod!");
		return PLUGIN_HANDLED;
	}

	if(current_jps >= get_cvar_num(CVAR_JP_MAX)) {
		client_print(id , print_chat , "[AMXX] Nemvehetsz tbb Jetpackot, mivel mr elrtk a limitet!");
		return PLUGIN_HANDLED;
	}

	new iMoney = cs_get_user_money(id) - get_cvar_num(CVAR_JP_COST);

	if(iMoney < 0) {
		client_print(id , print_chat , "[AMXX] Nincs elg pnzed! ra: $%d" , get_cvar_num(CVAR_JP_COST));
		return PLUGIN_HANDLED;
	}

	cs_set_user_money(id , iMoney , 1);

	has_jp[id] = true;

	client_print(id , print_chat , "[AMXX] A Jetpack hasznlatjoz hasznld az Ugrst+CTRL-t");
	client_print(id , print_chat , "[AMXX] A Jetpack eldobshoz rrd be hogy /dropjp a chatbe");

	emit_sound(id , CHAN_VOICE , "items/gunpickup2.wav" , 1.0 , ATTN_NORM , 0 , PITCH_NORM);

	current_jps++;

	return PLUGIN_HANDLED;
}

public drop_jp(id) {
	if(!has_jp[id]) return PLUGIN_HANDLED;

	new Float:fAim[3] , Float:fOrigin[3];
	VelocityByAim(id , 64 , fAim);
	entity_get_vector(id , EV_VEC_origin , fOrigin);

	fOrigin[0] += fAim[0];
	fOrigin[1] += fAim[1];

	new jp = create_entity("info_target");

	entity_set_string(jp , EV_SZ_classname , "jetpack");
	entity_set_model(jp , "models/w_egon.mdl");

	entity_set_size(jp , Float:{-16.0,-16.0,-16.0} , Float:{16.0,16.0,16.0});

	entity_set_int(jp , EV_INT_solid , 1);
	entity_set_int(jp , EV_INT_movetype , 6);

	entity_set_vector(jp , EV_VEC_origin , fOrigin);

	has_jp[id] = false;

	return PLUGIN_HANDLED;
}

public mmm_touchy(jp , id) {
	if(!is_user_alive(id)) return PLUGIN_CONTINUE;
	if(has_jp[id]) return PLUGIN_CONTINUE;

	has_jp[id] = true;

	emit_sound(id , CHAN_VOICE , "items/gunpickup2.wav" , 1.0 , ATTN_NORM , 0 , PITCH_NORM);

	remove_entity(jp);

	return PLUGIN_CONTINUE;
}